<?php
class AnonChat { const TRIGGER_DATE = 'date'; const TRIGGER_EVENT = 'event'; const TRIGGER_TUTORIAL = 'tutorial'; const TRIGGER_MANUAL = 'manual'; const STATUS_UNREAD = 0; const STATUS_READ = 1; private $id; private $title; private $message; private $isRead; private $triggerType; private $triggerCondition; private $year; private $month; private $folder; private $createdAt; private $readAt; private $metadata; public function __construct($data) { $this->id = $data['id'] ?? null; $this->title = $data['title']; $this->message = $data['message']; $this->isRead = $data['is_read'] ?? self::STATUS_UNREAD; $this->triggerType = $data['trigger_type']; $this->triggerCondition = $data['trigger_condition'] ?? null; $this->year = $data['year'] ?? null; $this->month = $data['month'] ?? null; $this->folder = $data['folder'] ?? 'inbox'; $this->createdAt = $data['created_at'] ?? null; $this->readAt = $data['read_at'] ?? null; $this->metadata = $data['metadata'] ?? null; } public function getId() { return $this->id; } public function getTitle() { return $this->title; } public function getMessage() { return $this->message; } public function getIsRead() { return $this->isRead; } public function getTriggerType() { return $this->triggerType; } public function getTriggerCondition() { return $this->triggerCondition; } public function getYear() { return $this->year; } public function getMonth() { return $this->month; } public function getFolder() { return $this->folder; } public function getCreatedAt() { return $this->createdAt; } public function getReadAt() { return $this->readAt; } public function getMetadata() { return $this->metadata; } public function isCipherMessage() { if ($this->metadata) { $metadata = json_decode($this->metadata, true); return isset($metadata['is_cipher']) && $metadata['is_cipher']; } return false; } public function markAsRead() { $this->isRead = self::STATUS_READ; $this->readAt = date('Y-m-d H:i:s'); } public function moveToFolder($folder) { if (in_array($folder, ['inbox', 'archive', 'deleted'])) { $this->folder = $folder; return true; } return false; } public function save($db) { if ($this->id) { $db->query( "UPDATE anonchat_messages SET
                title = ?,
                message = ?,
                is_read = ?,
                trigger_type = ?,
                trigger_condition = ?,
                year = ?,
                month = ?,
                folder = ?,
                read_at = ?,
                metadata = ?
                WHERE id = ?", [ $this->title, $this->message, $this->isRead, $this->triggerType, $this->triggerCondition, $this->year, $this->month, $this->folder, $this->readAt, $this->metadata, $this->id ] ); } else { $db->query( "INSERT INTO anonchat_messages (
                    title, message, is_read, trigger_type, trigger_condition, year, month, folder, read_at, metadata
                ) VALUES (
                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                )", [ $this->title, $this->message, $this->isRead, $this->triggerType, $this->triggerCondition, $this->year, $this->month, $this->folder, $this->readAt, $this->metadata ] ); $result = $db->query("SELECT last_insert_rowid() as id")->fetch(PDO::FETCH_ASSOC); $this->id = $result['id']; } return $this->id; } public static function getById($db, $id) { $result = $db->query("SELECT * FROM anonchat_messages WHERE id = ?", [$id])->fetch(PDO::FETCH_ASSOC); return $result ? new self($result) : null; } public static function getAll($db) { $stmt = $db->query("SELECT * FROM anonchat_messages ORDER BY created_at DESC"); $messages = []; while ($message = $stmt->fetch(PDO::FETCH_ASSOC)) { $messages[] = new self($message); } return $messages; } public static function getUnread($db) { $stmt = $db->query("SELECT * FROM anonchat_messages WHERE is_read = " . self::STATUS_UNREAD . " ORDER BY created_at DESC"); $messages = []; while ($message = $stmt->fetch(PDO::FETCH_ASSOC)) { $messages[] = new self($message); } return $messages; } public static function countUnread($db) { $stmt = $db->query("SELECT COUNT(*) FROM anonchat_messages WHERE is_read = " . self::STATUS_UNREAD); return $stmt->fetchColumn(); } public static function checkForNewMessages($db, $currentYear, $currentMonth) { $result = $db->query( "SELECT * FROM anonchat_messages
             WHERE is_read = " . self::STATUS_UNREAD . "
             AND trigger_type = '" . self::TRIGGER_DATE . "'
             AND year = ? AND month = ?
             AND (metadata IS NULL OR metadata NOT LIKE '%is_cipher%')", [$currentYear, $currentMonth] ); $messages = []; while ($message = $result->fetch(PDO::FETCH_ASSOC)) { $messages[] = new self($message); } return $messages; } public static function addMessage($db, $title, $message, $triggerType, $triggerCondition = null, $year = null, $month = null, $folder = 'inbox', $metadata = null) { $anonChatMessage = new self([ 'title' => $title, 'message' => $message, 'trigger_type' => $triggerType, 'trigger_condition' => $triggerCondition, 'year' => $year, 'month' => $month, 'folder' => $folder, 'metadata' => $metadata ]); return $anonChatMessage->save($db); } } 